unit Dbf2isam;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Isamtabl, Gauges, DB, DBTables, ExtCtrls,
  U_DbTool, Grids, DBGrids;

type
  DBASEImportProc = Procedure(var DATA; DBTable: TTable; ISTable: TIsamTable);

  TDBF2ISAMImportDlg = class(TForm)
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Table1: TTable;
    Gauge1: TGauge;
    IsamTable1: TIsamTable;
    StartBttn: TBitBtn;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    GroupBox1: TGroupBox;
    aktualRadio: TRadioButton;
    appendradio: TRadioButton;
    appendandupdateradio: TRadioButton;
    procedure CancelBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure StartBttnClick(Sender: TObject);
  private
    { Private declarations }
  public
    FieldGetProc: DBASEImportProc;
    Data,Dup    : Pointer;
  end;

var
  DBF2ISAMImportDlg: TDBF2ISAMImportDlg;

Procedure DBase2Isam(aParent: TForm;
                     IsamTable: TIsamTable;
                     DBASETableName: String;
                     AliasName: String;
                     FieldGet: DBASEImportProc);

implementation

Uses SysUtils, UToolDll, Filer;

{$R *.DFM}

procedure TDBF2ISAMImportDlg.CancelBtnClick(Sender: TObject);
begin
  Close;
end;

Procedure DBase2Isam(aParent: TForm;
                     IsamTable: TIsamTable;
                     DBASETableName: String;
                     AliasName: String;
                     FieldGet: DBASEImportProc);
var AktDir: String;
begin
  if Pos('.',DBaseTableName) > 0 then DBaseTableName:= Copy(DBaseTableName,1,Pos('.',DBaseTableName)-1);
  DBaseTableName:= DBaseTableName + '.DBF';
  AktDir:= ExtractFilePath(Application.ExeName);
  Check_Alias(AliasName,AktDir);
  DBF2IsamImportDlg:= TDBF2IsamImportDlg.Create(aParent);
  Try
    Dbf2IsamImportDlg.IsamTable1:= IsamTable;
    Dbf2IsamImportDlg.Table1.DataBaseName:= AliasName;
    Dbf2IsamImportDlg.Table1.TableName:= DBaseTableName;
    Dbf2IsamImportDlg.FieldGetProc:= FieldGet;
    Dbf2IsamImportDlg.ShowModal;
  Finally
    Dbf2IsamImportDlg.Free;
  end;
end;

procedure TDBF2ISAMImportDlg.FormDestroy(Sender: TObject);
begin
  FreeMem(Data,IsamTable1.RecSize);
  FreeMem(Dup,IsamTable1.RecSize);
  if Table1.Active then Table1.Close;
end;

procedure TDBF2ISAMImportDlg.FormCreate(Sender: TObject);
begin
  FieldGetProc:= NIL;
  if Sprache = 1 then begin
    GroupBox1.Caption:= 'Options';
    AktualRadio.Caption:= 'update only';
    AppendRadio.Caption:= 'append new only';
    AppendAndUpdateRadio.Caption:= 'append and update';
    CancelBtn.Caption:= 'End';
  end;
end;

procedure TDBF2ISAMImportDlg.FormShow(Sender: TObject);
begin
  GetMem(Data,IsamTable1.RecSize);
  GetMem(Dup,IsamTable1.RecSize);
  Table1.Open;
end;

procedure TDBF2ISAMImportDlg.StartBttnClick(Sender: TObject);
var i,RCount: Longint;
    Altprogress,NeuProgress: Integer;
    Key1: IsamKeyStr;
begin
  if Table1.Active then begin
    if IsamTable1.Active then begin
      IsamTable1.KeyNo:= 1;
      RCount:= Table1.RecordCount;
      Table1.First;
      i:= 0;
      AltProgress:= 0;
      IsamOk:= True;
      Repeat
        if IsamOk then begin
          FieldGetProc(DATA^,Table1,IsamTable1);
          Key1:= IsamTable1.Key_Proc(Data^,IsamTable1.KeyNo);
          if IsamTable1.FindKey(Data^,Data^,Key1) then begin
            if (AppendAndUpdateRadio.Checked) or (AktualRadio.Checked) then
            IsamTable1.UpdateRecord(DATA^,DATA^);
          end
          else begin
            if (AppendAndUpdateRadio.Checked) or (AppendRadio.Checked) then
            IsamTable1.Append(DATA^,DATA^);
          end;
          Table1.Next;
        end;
        Inc(i);
        NeuProgress:= Round((i/RCount)*100);
        if AltProgress <> NeuProgress then begin
          AltProgress:= NeuProgress;
          Gauge1.Progress:= NeuProgress;
        end;
      Until (Table1.Eof) or (i = rCount);
    end
    else begin
      if Sprache = 1 then Errorwindow('Isamtable is not opened','')
      else Errorwindow('Isamtabelle ist nicht geffnet','');
    end;
  end
  else begin
    if Sprache = 1 then Errorwindow('Isamtable is not opened','')
    else Errorwindow('DBASE-Tabelle ist nicht geffnet','');
  end;
end;

end.
